#------------------------------------------------------------------------------
# bildAnzeigen.py 
#------------------------------------------------------------------------------
# Liest den Dateinamen eines Bildes von der Komandozeile und zeigt das Bild an.
#------------------------------------------------------------------------------
import sys, stddraw
from picture import Picture

#------------------------------------------------------------------------------
# Richte die Leinwand von stddraw so ein, dass ihre Breite bzw. Höhe
# die Breite bzw. Höhe des anzuzeigenden Bildes ist.
def richteLeinwandEin(bild):
    breite = bild.width()
    hoehe = bild.height()
    stddraw.setCanvasSize(breite,hoehe)

#------------------------------------------------------------------------------
# Zeige das Bild bild (Picture) auf der Leinwand von stddraw an.
def bildAnzeigen(bild):
    richteLeinwandEin(bild)
    stddraw.picture(bild)
    stddraw.show()

#------------------------------------------------------------------------------
# Lies den Dateinamen eines Bildes (.jpg oder .png) von der Kommandozeile
# und zeige das Bild an.
def modultest():
   dateiname = sys.argv[1]
   bild = Picture(dateiname)
   bildAnzeigen(bild)

#------------------------------------------------------------------------------
if __name__ == '__main__': modultest()
#------------------------------------------------------------------------------
# python3 bildAnzeigen.py Spektraltorte.jpg
#
