#--------------------------------------------------------------------------------
# farbeNachSW.py
#--------------------------------------------------------------------------------
# Liest den Dateinamen eines Bildes von der Kommandozeile
# und zeigt das Bild in schwarz-weiß an.
#--------------------------------------------------------------------------------

import sys, stddraw
from picture import Picture
from luminanz import luminanz
from color import Color
from bildAnzeigen import richteLeinwandEin

#--------------------------------------------------------------------------------
# graustufe(f) gibt die Graustufe (Typ Color) der Farbe f (Typ Color) zurück.
def graustufe(f):
  l = luminanz(f)
  return Color(l,l,l)

#-----  Hauptprogramm -----------------------------------------------------------
# Lies den Dateinamen des Bildes von der Kommandozeile
# und erzeuge das Picture-Objekt foto daraus.
dateiname = sys.argv[1]
foto = Picture(dateiname)

# Zeige das Bild an.
richteLeinwandEin(foto)
stddraw.picture(foto)
stddraw.show(1)

# Gehe zeilen- und spaltenweise alle Pixel des Bildes durch
# und ersetze dabei jede Pixel-Farbe durch ihre Luminanz.
# Wenn alle Ersetzungen in einer Zeile gemacht wurden, dann zeige das Bild an.
for z in range(foto.height()):
  for s in range(foto.width()):
    pixel_farbe = foto.get(s,z)
    g = graustufe(pixel_farbe)
    foto.set(s,z,g)
  stddraw.picture(foto)
  stddraw.show(10)

stddraw.show()

#--------------------------------------------------------------------------------
# python3 farbeNachSW.py Spektraltorte.jpg 
