#---------------------------------------------------------------------------------------
# farbverlaeufe.py
#---------------------------------------------------------------------------------------
# Stellt Funktionen für Farbverläufe von rot, blau und grün zur Verfügung.
# Für rot ist der Verlauf 
#   Color(0,0,0), Color(1,0,0),...,Color(255,0,0),Color(255,1,1),...,Color(255,255,255)
# Rot-Ton:  0              1              255             256               510 
# Für die anderen Farben ist das entsrpechend.
#---------------------------------------------------------------------------------------

import stddraw, color

#---------------------------------------------------------------------------------------
# rot(n) gibt ein Color-Objekt mit Rot-Ton n gemäß der obigen Darstellung zurück.
def rot(n):
  if n<=255:
    c = color.Color( n, 0, 0 )
  else:
    c = color.Color( 255, n-255, n-255)
  return c

#---------------------------------------------------------------------------------------
# gruen(n) gibt ein Color-Objekt mit Grün-Ton n gemäß der obigen Darstellung zurück.
def gruen(n):
  if n<=255:
    c = color.Color( 0, n, 0 )
  else:
    c = color.Color( n-255, 255, n-255)
  return c

#---------------------------------------------------------------------------------------
# blau(n) gibt ein Color-Objekt mit Blau-Ton n gemäß der obigen Darstellung zurück.
def blau(n):
  if n<=255:
    c = color.Color( 0, 0, n )
  else:
    c = color.Color( n-255, n-255, 255)
  return c

#---------------------------------------------------------------------------------------
# Das Hauptprogramm richtet eine Leinwand mit x-Skala 0...510 ein
# und malt für jedes n in 0...510 einen Streifen mit Farbe blau(n) an x-Position n.
# (Man muss die Streifen etwas dicker als 1 malen (wir nehmen 1.4), da sonst weiße
#  Streifen zwischen den Streifen entstehen (durch Rundungsfehler bei stddraw)).
#---------------------------------------------------------------------------------------
def hauptprogramm():
  stddraw.setCanvasSize(1200,800)
  stddraw.setXscale(0,510)

  for i in range(0,511):
    c = blau(i)
    stddraw.setPenColor(c)
    stddraw.filledRectangle(i, 0, 1.4, 1)

  stddraw.show()

#---------------------------------------------------------------------------------------
if __name__=='__main__': hauptprogramm()
#--------------------------------------------------------------------------------------- 
# python3 farbverlaeufe.py


