#--------------------------------------------------------------------------------------------------
# luminanz.py 
#--------------------------------------------------------------------------------------------------
# Liest zwei RGB-Farben (jeweils drei int-Werte) von der Kommandozeile ein.
# Anschließend wird ein Rechteck in der ersten Farbe gemalt
# und darauf die Luminanz der beiden Farben in der zweiten Farbe geschrieben.
#--------------------------------------------------------------------------------------------------

import sys, stddraw, color

#--------------------------------------------------------------------------------------------------
# farbeEinlesen(i) nimmt sys.argv[i], sys.argv[i+1], sys.argv[i+2] als drei RGB-Parameter
# und gibt die Farbe (Typ color) zurück.
def farbeEinlesen(i):
  r = int(sys.argv[i])
  g = int(sys.argv[i+1])
  b = int(sys.argv[i+2])
  farbe = color.Color(r,g,b)
  return farbe

#--------------------------------------------------------------------------------------------------
# luminanz(farbe) gibt die Luminanz von farbe (Typ Color) zurück.
def luminanz(farbe):
  l = 0.299*farbe.getRed() + 0.587*farbe.getGreen() + 0.114*farbe.getBlue()
  return int(round(l))

#--------------------------------------------------------------------------------------------------
def modultest():
  # Lies zwei Farben f1 und f2 von der Kommandozeile ein.
  f1 = farbeEinlesen(1)
  f2 = farbeEinlesen(4)

  # Male ein Rechteck mit Farbe f1.
  stddraw.setPenColor(f1)
  stddraw.filledRectangle(0.2,0.4,0.6,0.2)

  # Schreibe die Luminanz von f1 und f2 und deren Differenz in Farbe f2 darauf.
  stddraw.setPenColor(f2)
  text = "Die Farben haben Luminanz " + str(luminanz(f1)) + " und " + str(luminanz(f2)) + "."
  stddraw.text(0.5,0.5,text)
  text = "Die Luminanz-Differenz ist " + str(abs(luminanz(f1)-luminanz(f2))) + "."
  stddraw.text(0.5,0.45,text)
  stddraw.show()

#--------------------------------------------------------------------------------------------------
if __name__ == '__main__': modultest()
#--------------------------------------------------------------------------------------------------
# python3 luminanz.py 234 12 45  23 45 11
#
# python3 luminanz.py 234 12 45  234 245 210
#
