#---------------------------------------------------------------------------------------
# rot_farbverlauf.py
#---------------------------------------------------------------------------------------
# Malt den Farbverlauf von rot in Streifen mit den Farben 
#   Color(0,0,0), Color(1,0,0),...,Color(255,0,0),Color(255,1,1),...,Color(255,255,255)
#         0              1              255             256               510 
# auf die Leinwand von stddraw. (Die Zahl i unter der Farbe gibt den Rot-Ton an...)
#---------------------------------------------------------------------------------------

import stddraw, color

#---------------------------------------------------------------------------------------
# rot(n) gibt ein Color-Objekt mit Rot-Ton n gemäß der obigen Darstellung zurück.
def rot(n):
  if n<=255:
    c = color.Color( n, 0, 0 )
  else:
    c = color.Color( 255, n-255, n-255)
  return c

#---------------------------------------------------------------------------------------
# Die Testfunktion richtet eine Leinwand mit x-Skala 0...510 ein
# und malt für jedes n in 0...510 einen Streifen mit Farbe rot(n) an x-Position n.
# (Man muss die Streifen etwas dicker als 1 malen (wir nehmen 1.4), da sonst weiße
#  Streifen zwischen den Streifen entstehen (durch Rundungsfehler bei stddraw)).
#---------------------------------------------------------------------------------------
def maleRotverlauf():
  stddraw.setCanvasSize(1200,800)
  stddraw.setXscale(0,510)

  for i in range(0,511):
    c = rot(i)
    stddraw.setPenColor(c)
    stddraw.filledRectangle(i, 0, 1.4, 1)

  stddraw.show()

#---------------------------------------------------------------------------------------
if __name__=='__main__': maleRotverlauf()
#---------------------------------------------------------------------------------------
# python3 rot_farbverlauf.py



