#------------------------------------------------------------------------------------------------------
# temperaturStreifen.py
#------------------------------------------------------------------------------------------------------
# Liest den Namen einer Datei von der Kommandozeile, deren Zeilen aus einer Jahreszahl und
# einem Zahlenwert (float) bestehen (z.B. Jahresdurchschnittstemperaturen).
# Die Zahlenwerte werden als Streifendiagramm graphisch dargestellt.
# Die Werte unter dem Durchschnitt werden durch blaue Streifen dargestellt (je kleiner, umso dunkler),
# die Werte über dem Durchschnitt werden durch rote Streifen dargestellt (je größer, umso dunkler).
#------------------------------------------------------------------------------------------------------

import sys, stddraw
from farbverlaeufe import blau, rot

#------------------------------------------------------------------------------------------------------
# liesEingabe(dateiname) liest die Eingabedatei aus der Datei mit Namen dateiname (string).
# Die Datei wird als Tabelle aus zwei Spalten (getrennt durch ' ') aufgefasst.
# Die zweite Spalte wird in einem Array zurückgegeben.
def liesEingabe(dateiname):
  # Öffne die Datei und lies die erste Zeile.
  datei = open(dateiname, 'r')
  # werte speichert die Werte der zweiten Spalte.
  werte = []
  # Solange aus der Datei noch eine Zeile gelesen werden konnte:
  #   speichere den Wert aus der 2.Spalte in werte und lies die nächste Zeile.
  zeile = datei.readline()
  while zeile != '':
     wert = float( str.split(zeile)[1] )
     werte += [ wert ]
     zeile = datei.readline()
  # Gib alle eingelesenen Werte zurück.
  return werte

#------------------------------------------------------------------------------------------------------
# Gibt einen ganzzahligen Wert aus dem Bereich 0..510 zurück, der wert auf der
# Skala unten..oben nach dem Umskalieren auf 0..510 entspricht. 
def skaliere(wert, unten, oben):
  m  = 360*(wert-unten)/(oben-unten) + 75     # vermeide 0..75 und 510-75..510
  return round(m)

#------------------------------------------------------------------------------------------------------
# Erhält ein Array aus Zahlenwerten und wandelt sie in Farben um.
# Werte unter dem Mittelwert werden in Blautöne umgewandelt.
#   Kleine Werte haben dunklere Blautöne als größere Werte.
# Werte über dem Mittelwert werden in Rottöne umgewandelt.
#   Kleine Werte haben hellere Rottöne als größere Werte.
# Das Array mit den in Farben umgewandelten Werten wird zurückgegeben.
def werteZuFarben(werte):
   # Bestimme den Bereich der Werte und seinen Durchschnittswert.
   durchschnittsWert = sum(werte)/len(werte)
   minWert = min(werte)
   maxWert = max(werte)
   # Das Array farben wird am Ende in farbe[i] die Farbe zu werte[i] enthalten.
   farben = []
   # Wandele die Werte der Reihe nach in Farben um.
   for w in werte:
     # Falls der Wert kleiner als der Durchschnitt ist, wird er in einen Blauton umgewandelt.
     # Je kleiner der Wert ist, umso dunkler ist das Blau.
     if w<=durchschnittsWert:  
         farben += [ blau( skaliere(w, minWert, durchschnittsWert) ) ]
     else:
     # Falls der Wert größer als der Durchschnitt ist, wird er in einen Rotton umgewandelt.
     # Je größer der Wert ist, desto dunkler ist das Rot.
        farben += [ rot( 510 - skaliere(w, durchschnittsWert, maxWert) ) ]

   return farben

#------------------------------------------------------------------------------------------------------
# Male die Farben als Streifen auf die Leinwand.
def maleStreifen(farben):
   # Male die Streifen in den angegebenen Farben der Reihe nach von links nach rechts auf die Leinwand.
   for i in range(0,len(farben)):
     stddraw.setPenColor(farben[i])
     stddraw.filledRectangle(i, 0, 1.1, 1)

#------------------------------------------------------------------------------------------------------
# Lies die darzustellenden Werte aus einer Datei,
# wandele die Werte in Farben um und male sie als Streifen auf die Leinwand.
def hauptprogramm(dateiname):
   # Lies die darzustellenden Werte aus der Datei, deren Name von der Kommandozeile gelesen wird.
   werte = liesEingabe(dateiname)
   # Wandele die Werte in Farben um.
   farben = werteZuFarben(werte)
   # Richte die Leinwand zum Malen ein.
   stddraw.setCanvasSize(1200,800)
   stddraw.setXscale(0, len(werte))
   # Male die Farben als Streifen auf die Leinwand und zeige das Bild an.
   maleStreifen(farben)
   stddraw.save('streifen2.png')
   stddraw.show()
#------------------------------------------------------------------------------------------------------
if __name__=='__main__': hauptprogramm(sys.argv[1])
#------------------------------------------------------------------------------------------------------
# python3 temperaturStreifen.py Jena-JahresMittel-Temp.txt
#------------------------------------------------------------------------------------------------------
